import mplfinance as mpf
import matplotlib.pyplot as plt
from io import BytesIO

class Plotting:
	def generate_candlesticks(self, df, symbol):
			# Use only the last 100 rows for plotting
			df = df.tail(100)

			# Prepare the DataFrame for mplfinance
			df = df.rename(columns={
					'Open': 'Open',
					'High': 'High',
					'Low': 'Low',
					'Close': 'Close',
			})
			df.index.name = 'Date'  # Ensure the index is named 'Date'

			# Define colors for bullish and bearish candles
			mc = mpf.make_marketcolors(
					up='green',  # Bullish candles
					down='red',  # Bearish candles
					wick={'up': 'green', 'down': 'red'},  # Wick colors
					volume='blue',  # Volume bars (optional)
					edge='inherit'  # Edge inherits color from body
			)
			s = mpf.make_mpf_style(marketcolors=mc)

			ap = [
					mpf.make_addplot(df['SMA_50'], color='orange', label='SMA 50'),
					mpf.make_addplot(df['SMA_200'], color='purple', label='SMA 200'),
					mpf.make_addplot(df['BBU_20_2.0'], color='red', linestyle='--', label='Upper Bollinger Band'),
					mpf.make_addplot(df['BBL_20_2.0'], color='green', linestyle='--', label='Lower Bollinger Band')
			]
			fig, axlist = mpf.plot(
					df,
					type='candle',
					style=s,
					title=f"{symbol} Candlestick Chart",
					ylabel='Price',
					xrotation=45,
					volume=False,
					addplot=ap,
					returnfig=True,
					figsize=(10, 8)
			)

			# Save the plot to a BytesIO buffer
			buffer = BytesIO()
			fig.savefig(buffer, format='png')
			buffer.seek(0)
			plt.close(fig)

			return buffer