# Dictionary to store user portfolios
user_portfolios = {}

def add_stock_to_portfolio(user_id, symbol, quantity, purchase_price):
		if user_id not in user_portfolios:
				user_portfolios[user_id] = {}
		if symbol not in user_portfolios[user_id]:
				user_portfolios[user_id][symbol] = {
						"quantity": 0,
						"total_cost": 0,
						"average_purchase_price": 0
				}
		# Update total cost and quantity
		total_cost = user_portfolios[user_id][symbol]["total_cost"] + (purchase_price * quantity)
		total_quantity = user_portfolios[user_id][symbol]["quantity"] + quantity
		average_purchase_price = total_cost / total_quantity

		user_portfolios[user_id][symbol]["quantity"] = total_quantity
		user_portfolios[user_id][symbol]["total_cost"] = total_cost
		user_portfolios[user_id][symbol]["average_purchase_price"] = average_purchase_price

def remove_stock_from_portfolio(user_id, symbol):
		if user_id in user_portfolios and symbol in user_portfolios[user_id]:
				del user_portfolios[user_id][symbol]

def get_portfolio(user_id):
		return user_portfolios.get(user_id, {})

def calculate_portfolio_metrics(portfolio, provider):
		metrics = {}
		total_value = 0
		total_profit_loss = 0

		print(portfolio)
		for data in portfolio:
				try:
						latest_price = provider.fetch_latest_price(data["symbol"])
						quantity = data["quantity"]
						total_cost = data["purchase_price"]
						average_purchase_price = data["average_purchase_price"]

						# Calculate metrics
						current_value = latest_price * quantity
						profit_loss = current_value - total_cost
						percentage_change = (profit_loss / total_cost) * 100

						metrics[data["symbol"]] = {
								"quantity": quantity,
								"average_purchase_price": average_purchase_price,
								"latest_price": latest_price,
								"current_value": current_value,
								"profit_loss": profit_loss,
								"percentage_change": percentage_change
						}

						total_value += current_value
						total_profit_loss += profit_loss

				except Exception as e:
						metrics[data["symbol"]] = {"error": str(e)}
		return metrics, total_value, total_profit_loss