def format_options(options):
    if not options:
        return "No options data available."

    message = "Options Data:\n\n"
    for option in options:
        strike_price = option.get("strike_price", "N/A")
        expiration_date = option.get("expiration_date", "N/A")
        option_type = option.get("option_type", "N/A")
        last_price = option.get("last_price", "N/A")
        message += f"- Type: {option_type}, Strike Price: ${strike_price}, Expiration: {expiration_date}, Last Price: ${last_price}\n"

    return message