def format_dividends(dividends_data):
		if not dividends_data:
				return "No dividends found for this symbol."
				
		message = "Latest Dividends:\n\n"

		for dividend in dividends_data:
				ex_dividend_date = dividend.get("exDate", "N/A")
				payment_date = dividend.get("paymentDate", "N/A")
				amount = dividend.get("amount", "N/A")
				record_date = dividend.get("recordDate", "N/A")

				# Add each dividend's details to the message
				message += (
						f"- Ex-Dividend Date: {ex_dividend_date}\n"
						f"  Payment Date: {payment_date}\n"
						f"  Amount: ${amount:.2f} per share\n"
						f"  Record Date: {record_date}\n\n"
				)

		# Add an explanation of the output
		message += (
				"\nExplanation:\n"
				"<b>- The Ex-Dividend Date</b> is the last day you can buy the stock and still receive the dividend.\n"
				"<b>- The Payment Date</b> is when the dividend is paid to shareholders.\n"
				"<b>- The Amount</b> is the dividend payout per share.\n"
				"<b>- The Record Date</b> is the date on which the company reviews its records to determine who is eligible for the dividend."
		)

		return message