def compare_stocks(stocks_data_daily, stocks_data_weekly):
    message = "Comparison Results:\n\n"

    for symbol in stocks_data_daily.keys():
        # Daily Metrics
        daily_df = stocks_data_daily[symbol]
        latest_price = daily_df['Close'].iloc[-1]
        previous_price = daily_df['Close'].iloc[-2] if len(daily_df) > 1 else None
        daily_return = ((latest_price - previous_price) / previous_price * 100) if previous_price else 0

        # Weekly Metrics
        weekly_df = stocks_data_weekly[symbol]
        weekly_returns = weekly_df['Close'].pct_change().dropna() * 100
        avg_daily_return = weekly_returns.mean()
        total_return = ((weekly_df['Close'].iloc[-1] - weekly_df['Close'].iloc[0]) / weekly_df['Close'].iloc[0]) * 100
        volatility = weekly_returns.std()

        # Append results to the message
        message += (
            f"<b>{symbol}</b>:\n"
            f"- Latest Price: ${latest_price:.2f}\n"
            f"- Daily Return: {daily_return:.2f}%\n"
            f"- 1-Week Average Daily Return: {avg_daily_return:.2f}%\n"
            f"- 1-Week Total Return: {total_return:.2f}%\n"
            f"- 1-Week Volatility: {volatility:.2f}%\n\n"
        )

    # Add a conclusion based on the results
    best_symbol_weekly = max(stocks_data_weekly.keys(), key=lambda s: stocks_data_weekly[s]['Close'].iloc[-1])
    worst_symbol_weekly = min(stocks_data_weekly.keys(), key=lambda s: stocks_data_weekly[s]['Close'].iloc[-1])
    message += (
        f"Conclusion:\n"
        f"- Best performer over 1 week: <b>{best_symbol_weekly}</b>\n"
        f"- Worst performer over 1 week: <b>{worst_symbol_weekly}</b>"
    )

    return message