from sqlalchemy import Column, String, Integer, Numeric, BIGINT
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()

# Watchlist Table
class Watchlist(Base):
    __tablename__ = "watchlist"
    user_id = Column(BIGINT, primary_key=True)
    symbol = Column(String(10), primary_key=True)

# Portfolio Table
class Portfolio(Base):
    __tablename__ = "portfolio"
    user_id = Column(BIGINT, primary_key=True)
    symbol = Column(String(10), primary_key=True)
    quantity = Column(Integer, nullable=False)
    purchase_price = Column(Numeric(10, 2), nullable=False)
    average_purchase_price = Column(Numeric(10, 2), nullable=True)