# Forex and Stock Analysis Bot

![GitHub](https://img.shields.io/github/license/ghkobbs/signal-pulse) ![Python](https://img.shields.io/badge/python-3.10-blue)

A Telegram bot designed to analyze forex pairs and stocks using technical indicators like SMA, RSI, Bollinger Bands, MACD, and ATR. The bot provides buy/sell signals, stop-loss (SL), take-profit (TP), and risk/reward calculations. It also generates candlestick charts and supports advanced features like real-time data streaming (future feature).

---

## Table of Contents

1. [Features](#features)
2. [Prerequisites](#prerequisites)
3. [Setup Instructions](#setup-instructions)
4. [Running the Bot Locally](#running-the-bot-locally)
5. [Running the Bot with Docker](#running-the-bot-with-docker)
6. [Usage](#usage)
7. [Commands](#commands)
8. [Contributing](#contributing)
9. [License](#license)

---

## Dependencies

- `dotenv`: Load environment variables.
- `requests`: Fetch data from APIs.
- `pandas`: Data manipulation and analysis.
- `telegram`: Telegram bot integration.
- `pandas_ta`: Technical analysis library.
- `mplfinance`: Candlestick chart visualization.
- `matplotlib`: Plotting library.

---

## Features

- **Technical Analysis**:
  - Moving Averages (SMA 50, SMA 200)
  - Relative Strength Index (RSI)
  - Bollinger Bands
  - MACD (Moving Average Convergence Divergence)
  - ATR (Average True Range)

- **Trading Signals**:
  - Buy/Sell signals based on technical indicators.
  - Stop-Loss (SL) and Take-Profit (TP) levels using ATR.
  - Risk/Reward calculations.

- **Visualization**:
  - Candlestick charts with indicators plotted (e.g., SMA, Bollinger Bands).

- **Risk Management**:
  - Monetary risk/reward estimates for each trade.

- **Extensibility**:
  - Modular design allows for easy addition of new indicators or features.

---

## Prerequisites

Before running the bot, ensure you have the following:

1. **Telegram Bot Token**:
   - Create a bot using [@BotFather](https://t.me/BotFather) and obtain the API token.

2. **Forex API Key**:
   - Sign up for an API key from [Alpha Vantage](https://www.alphavantage.co/).
   - Sign up for an API key from [Polygon.io](https://polygon.io/).

3. **Python 3.10+**:
   - Install Python from [python.org](https://www.python.org/).

4. **Docker** (Optional):
   - Install Docker from [docker.com](https://www.docker.com/).

---

## Setup Instructions

### Step 1: Clone the Repository

```bash
git clone https://github.com/ghkobbs/signal-pulse.git
cd signal-pulse
```

### Step 2: Install Dependencies

Install the required Python packages:

```bash
pip install -r requirements.txt
```

### Step 3: Configure Environment Variables

Create a `.env` file in the root directory and add your API keys:

```plaintext
TELEGRAM_BOT_TOKEN=your_telegram_bot_token_here
ALPHA_VANTAGE_API_KEY=your_alpha_vintage_api_key_here
POLYGON_API_KEY=your_polygon_api_key_here
```

---

## Running the Bot Locally

### Step 1: Run the Bot

Start the bot using the following command:

```bash
python main.py
```

The bot will start polling for updates and respond to commands.

---

## Running the Bot with Docker

### Step 1: Build the Docker Image

Build the Docker image using the provided `Dockerfile`:

```bash
docker build -t signal-pulse .
```

### Step 2: Run the Docker Container

Run the bot in a Docker container:

```bash
docker run -d --name signal-pulse -v $(pwd)/.env:/app/.env signal-pulse
```

This command mounts your `.env` file into the container for secure access to API keys.

---

## Usage

Interact with the bot via Telegram by sending commands. Below are examples of how to use the bot:

### Example 1: Analyze a Forex Pair

```plaintext
/analyze EURUSD 50 1
```

This analyzes the `EURUSD` pair using the last 50 days of data with a lot size of 1.

### Example 2: Generate Buy/Sell Signals

The bot will generate buy/sell signals based on technical indicators like SMA, RSI, and Bollinger Bands. For example:

- **Bullish SMA Crossover**: Buy Signal
  - Entry Price: 1.1000
  - Stop-Loss (SL): 1.0950 (50 pips)
  - Take-Profit (TP): 1.1100 (100 pips)
  - Monetary Risk: $500, Monetary Reward: $1000

---

## Commands

| Command               | Description                                                                 |
|-----------------------|-----------------------------------------------------------------------------|
| `/start`              | Start the bot and get a welcome message.                                   |
| `/help`  						  | More information on how to use the bot.                  										|
| `/analyze <pair> [days] [lot_size] [asset_type]`     | Analyze a forex pair or stock using technical indicators.                  |
| `/setprovider`        | Set your preferred data provider (e.g., alphavantage, polygon).             |
| `/news <symbol>`      | Fetch recent news articles for a stock.   |
| `/dividends <symbol>`      | Get upcoming dividend information for a stock.   |
| `/options <symbol>`      | Fetch options data for a stock.   |
| `/portfolio add <symbol> <quantity> <purchase_price>`      | Add a stock to your portfolio.                                             |
| `/portfolio view`     | View your current portfolio with metrics like current value and profit/loss.|
| `/portfolio remove <symbol>`     | Remove a stock from your portfolio.|
| `/earnings <symbol>`     | Get upcoming earnings reports for a stock.|
| `/compare <symbol> <symbol> ...`     | Compare multiple stocks.|
| `/sector `     | View sector performance for the US market.|
| `/risk <account_balance> <risk_percentage> <stop_loss_pips> <pip_value>`     | Calculate position sizing based on risk management.|
| `/watchlist add <symbol>`      | Add a stock to your watchlist.                                             |
| `/watchlist view`     | View your watchlist with performance metrics.|
| `/watchlist remove <symbol>`     | Remove a stock from your watchlist.|
| `/screener <filters>` | Screen stocks based on filters like volume, RSI, and moving averages.       |
| `/learn <topic>`      | Learn about trading concepts like SMA, RSI, Fibonacci Retracements, etc.   |
| `/learn <topic> [symbol]`      | Learn about trading concepts with real time symbol example (e.g., sma, rsi).   |
| `/learn <topic> [symbol] [chart]`      | Learn about trading concepts with real time symbol example and chart (e.g., sma, rsi).   |
| `/learn <topic> [symbol] [chart] [...args]`      | Learn about trading concepts with real time symbol example chart plus filters (e.g., sma, rsi).   |

---

## Contributing

We welcome contributions! To contribute:

1. Fork the repository.
2. Create a new branch (`git checkout -b feature/your-feature`).
3. Commit your changes (`git commit -m "Add your feature"`).
4. Push to the branch (`git push origin feature/your-feature`).
5. Open a pull request.

---

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

---

## Acknowledgments

- [Alpha Vantage](https://www.alphavantage.co/) for providing forex and stock data.
- [mplfinance](https://github.com/matplotlib/mplfinance) for candlestick chart visualization.
- [pandas-ta](https://github.com/twopirllc/pandas-ta) for technical analysis indicators.

