import requests
import pandas as pd
from providers.base_provider import BaseProvider
from config.settings import ALPHA_VANTAGE_API_KEY

class AlphaVantageProvider(BaseProvider):

	def fetch_data(self, symbol, interval="DAILY", api_key=ALPHA_VANTAGE_API_KEY):
			url = f"https://www.alphavantage.co/query?function=FX_{interval}&from_symbol={symbol[:3]}&to_symbol={symbol[3:]}&apikey={api_key}&outputsize=full"
			response = requests.get(url)
			data = response.json()

			if "Error Message" in data:
				if "Invalid API call" in data.get("Error Message"):
					raise Exception("Error fetching data:", "Invalid API call")
				raise Exception("Error fetching data:", data.get("Error Message", "Unknown error"))
			
			if "Time Series FX ("+interval.capitalize()+")" in data:
					df = pd.DataFrame.from_dict(data["Time Series FX ("+interval.capitalize()+")"], orient="index")
					df.columns = ["Open", "High", "Low", "Close"]
					df = df.astype(float)

					# Convert index to DatetimeIndex
					df.index = pd.to_datetime(df.index)

					# Forward-fill missing dates
					df = df.resample('D').ffill()

					# Add a dummy "Volume" column
					df['Volume'] = 0

					if (df.index[-1] - df.index[0]).days < 365:
						raise Exception("Insufficient historical data for analysis.")

					return df.sort_index()
			else:
					raise Exception("Error fetching data:", data.get("Error Message", "Unknown error"))