import os
import psycopg2
from psycopg2 import sql

def get_db_connection():
    try:
        connection = psycopg2.connect(
            dbname=os.getenv("DB_NAME", "telegram_bot"),
            user=os.getenv("DB_USER", "bot_user"),
            password=os.getenv("DB_PASSWORD", "your_password"),
            host=os.getenv("DB_HOST", "localhost"),
            port=os.getenv("DB_PORT", "5432")
        )
        return connection
    except Exception as e:
        raise Exception(f"Error connecting to the database: {str(e)}")