
def calculate_sl_tp(close_price, atr_value, symbol, signal_type="buy", risk_reward_ratio=2):
    # Define pip size based on the forex pair
    if "JPY" in symbol.upper():
        pip_size = 0.01  # 1 pip = 0.01 for JPY pairs
    else:
        pip_size = 0.0001  # 1 pip = 0.0001 for other pairs

    # Calculate SL and TP distances based on ATR
    sl_distance = atr_value * 1.5  # 1.5x ATR for SL
    tp_distance = sl_distance * risk_reward_ratio  # Risk-to-reward ratio (e.g., 1:2)

    # Adjust SL and TP based on signal type
    if signal_type == "buy":
        sl_price = close_price - sl_distance  # SL below entry price for buy
        tp_price = close_price + tp_distance  # TP above entry price for buy
    elif signal_type == "sell":
        sl_price = close_price + sl_distance  # SL above entry price for sell
        tp_price = close_price - tp_distance  # TP below entry price for sell
    else:
        raise ValueError("Invalid signal_type. Must be 'buy' or 'sell'.")

    return sl_price, tp_price

def calculate_risk_reward(close_price, sl_price, tp_price, lot_size=1):
		# Define pip value based on lot size
		pip_value_per_lot = 10  # $10 per pip for standard lot size (1.0)
		pip_value = pip_value_per_lot * lot_size

		# Calculate risk and reward in pips
		risk_pips = abs(close_price - sl_price) / 0.0001  # For non-JPY pairs
		reward_pips = abs(tp_price - close_price) / 0.0001  # For non-JPY pairs

		# Calculate monetary risk and reward
		monetary_risk = risk_pips * pip_value
		monetary_reward = reward_pips * pip_value

		return monetary_risk, monetary_reward
