import pandas_ta as ta
import pandas as pd

def calculate_indicators(df):
    # Moving Averages
    df['SMA_50'] = ta.sma(df['Close'], length=50)
    df['SMA_200'] = ta.sma(df['Close'], length=200)

    # RSI
    df['RSI'] = ta.rsi(df['Close'], length=14)

    # Bollinger Bands
    bbands = ta.bbands(df['Close'], length=20, std=2.0)
    df = pd.concat([df, bbands], axis=1)

    # MACD
    macd = ta.macd(df['Close'])
    df = pd.concat([df, macd], axis=1)

    # ATR (Average True Range)
    df['ATR'] = ta.atr(df['High'], df['Low'], df['Close'], length=14)

    df.dropna(inplace=True)

		# print(f"DataFrame shape after calculating indicators: {df.shape}")
    return df