"""create watchlist and portfolio tables

Revision ID: 629873bc6d70
Revises: 
Create Date: 2025-03-29 22:54:57.690117

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '629873bc6d70'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('portfolio',
    sa.Column('user_id', sa.BIGINT(), nullable=False),
    sa.Column('symbol', sa.String(length=10), nullable=False),
    sa.Column('quantity', sa.Integer(), nullable=False),
    sa.Column('purchase_price', sa.Numeric(precision=10, scale=2), nullable=False),
    sa.PrimaryKeyConstraint('user_id', 'symbol')
    )
    op.create_table('watchlist',
    sa.Column('user_id', sa.BIGINT(), nullable=False),
    sa.Column('symbol', sa.String(length=10), nullable=False),
    sa.PrimaryKeyConstraint('user_id', 'symbol')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('watchlist')
    op.drop_table('portfolio')
    # ### end Alembic commands ###
